/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.TestCapabilities;
import com.quantumdata.sct.dao.jaxb.TestCapabilitiesType;
import com.quantumdata.sct.dao.jaxb.TestCapability;
import com.quantumdata.sct.dao.vo.TestCapabilityVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.ArrayList;
import java.util.Iterator;

public final class TestCapabilityDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    private TestCapabilitiesType.TestCapabilityElement get(Integer n) throws ReadException {
        if (n == null) {
            throw new ReadException("Invalid index");
        }
        int n2 = ((TestCapabilities)this.daoObject).getTestCapabilitiesCollection().size();
        if (n >= n2) {
            throw new ReadException("Index out of bounds error");
        }
        TestCapabilitiesType.TestCapabilityElement testCapabilityElement = (TestCapabilitiesType.TestCapabilityElement)((TestCapabilities)this.daoObject).getTestCapabilitiesCollection().get(n);
        return testCapabilityElement;
    }

    public void readCallback() throws DAOException {
        try {
            TestCapabilities testCapabilities = (TestCapabilities)this.daoObject;
            int n = testCapabilities.getTestCapabilitiesCollection().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                TestCapabilitiesType.TestCapabilityElement testCapabilityElement = (TestCapabilitiesType.TestCapabilityElement)testCapabilities.getTestCapabilitiesCollection().get(i);
                this.daoCollection.put(testCapabilityElement.getTestID(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public final Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public final IPersistable getValueObjectForKey(Object object) throws CreateException {
        IPersistable iPersistable = null;
        try {
            if (!this.daoCollection.containsKey(object)) {
                throw new Exception("Element with key = " + object + " not found");
            }
            Integer n = (Integer)this.daoCollection.get(object);
            TestCapabilitiesType.TestCapabilityElement testCapabilityElement = this.get(n);
            iPersistable = this.createPersistable(testCapabilityElement);
        }
        catch (Exception exception) {
            throw new CreateException(exception.getMessage());
        }
        return iPersistable;
    }

    public final IPersistable[] findByAll() throws Exception {
        int n = ((TestCapabilities)this.daoObject).getTestCapabilitiesCollection().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            TestCapabilitiesType.TestCapabilityElement testCapabilityElement = (TestCapabilitiesType.TestCapabilityElement)((TestCapabilities)this.daoObject).getTestCapabilitiesCollection().get(i);
            iPersistableArray[i] = this.createPersistable(testCapabilityElement);
        }
        return iPersistableArray;
    }

    public final Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof TestCapabilitiesType.TestCapabilityElement) {
            TestCapabilitiesType.TestCapabilityElement testCapabilityElement = (TestCapabilitiesType.TestCapabilityElement)object;
            object2 = testCapabilityElement.getTestID();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    private IPersistable createPersistable(Object object) throws Exception {
        TestCapabilityVO testCapabilityVO = new TestCapabilityVO();
        if (object instanceof TestCapabilitiesType.TestCapabilityElement) {
            this.copyFrom((TestCapabilitiesType.TestCapabilityElement)object, testCapabilityVO);
        }
        return testCapabilityVO;
    }

    private void copyFrom(TestCapabilitiesType.TestCapabilityElement testCapabilityElement, TestCapabilityVO testCapabilityVO) throws Exception {
        testCapabilityVO.setId(testCapabilityElement.getTestID());
        testCapabilityVO.setLastUpdate(testCapabilityElement.getLastUpdate());
        testCapabilityVO.setPrimaryCapabilityId(testCapabilityElement.getPrimaryCapabilityId());
        testCapabilityVO.setAnti(testCapabilityElement.isAntiSecondaryCapabilities());
        testCapabilityVO.setPrimaryAnti(testCapabilityElement.isAntiPrimaryCapability());
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = testCapabilityElement.getSecondaryCapabilitiesCollection().size();
        for (int i = 0; i < n; ++i) {
            TestCapability.SecondaryCapabilityID secondaryCapabilityID = (TestCapability.SecondaryCapabilityID)testCapabilityElement.getSecondaryCapabilitiesCollection().get(i);
            arrayList.add(secondaryCapabilityID.getValue());
        }
        testCapabilityVO.setSecondaryCapabilitiesId(arrayList);
    }

    private void copyTo(TestCapabilitiesType.TestCapabilityElement testCapabilityElement, TestCapabilityVO testCapabilityVO) throws Exception {
        testCapabilityElement.setTestID(testCapabilityVO.getTestId());
        testCapabilityElement.setLastUpdate(testCapabilityVO.getLastUpdate());
        testCapabilityElement.setPrimaryCapabilityId(testCapabilityVO.getPrimaryCapabilityId());
        testCapabilityElement.setAntiSecondaryCapabilities(testCapabilityVO.isAnti());
        testCapabilityElement.setAntiPrimaryCapability(testCapabilityVO.isPrimaryAnti());
        Iterator iterator = testCapabilityVO.getSecondaryCapabilitiesId().iterator();
        while (iterator.hasNext()) {
            TestCapability.SecondaryCapabilityID secondaryCapabilityID = this.factory.createTestCapabilitySecondaryCapabilityID();
            String string = (String)iterator.next();
            secondaryCapabilityID.setValue(string);
            testCapabilityElement.getSecondaryCapabilitiesCollection().add(secondaryCapabilityID);
        }
    }

    protected final void updateObject(IPersistable iPersistable) throws Exception {
        if (iPersistable instanceof TestCapabilityVO) {
            TestCapabilityVO testCapabilityVO = (TestCapabilityVO)iPersistable;
            Integer n = (Integer)this.daoCollection.get(testCapabilityVO.getId());
            TestCapabilitiesType.TestCapabilityElement testCapabilityElement = this.get(n);
            this.copyTo(testCapabilityElement, testCapabilityVO);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        TestCapabilityVO testCapabilityVO = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                TestCapabilitiesType.TestCapabilityElement testCapabilityElement = this.get(n);
                testCapabilityVO = new TestCapabilityVO();
                this.copyFrom(testCapabilityElement, testCapabilityVO);
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            testCapabilityVO = null;
        }
        return testCapabilityVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                Integer n = (Integer)this.daoCollection.get(object);
                ((TestCapabilities)this.daoObject).getTestCapabilitiesCollection().remove(n);
            }
            this.flush();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public final void add(IPersistable iPersistable) throws CreateException {
        this.add(iPersistable, 0);
    }

    public final void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            if (iPersistable instanceof TestCapabilityVO) {
                TestCapabilitiesType.TestCapabilityElement testCapabilityElement = this.factory.createTestCapabilitiesTypeTestCapabilityElement();
                this.copyTo(testCapabilityElement, (TestCapabilityVO)iPersistable);
                if (n > 0) {
                    ((TestCapabilities)this.daoObject).getTestCapabilitiesCollection().add(n, iPersistable);
                } else {
                    ((TestCapabilities)this.daoObject).getTestCapabilitiesCollection().add(iPersistable);
                }
            } else {
                throw new Exception("Invalid Value Object being passed");
            }
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

